# app/models/user.py
from webapp import *



class User(UserMixin, db.Model):
    __tablename__='_user'
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String(100)) 
    phone = db.Column(db.String(100)) #telephone number
    password = db.Column(db.String(256))
    account_type = db.Column(db.String(50), default="limited") #admin, limited, super
    active = db.Column(db.Boolean, default=True)
    allow_add= db.Column(db.Boolean, default=True)
    allow_delete=db.Column(db.Boolean, default=True)
    allow_update=db.Column(db.Boolean, default=True)
    timelocked=db.Column(db.Boolean, default=False)
    def __repr__(self):
        return f'User {self.username}'

class Log(db.Model):
    __tablename__="_log"
    id=db.Column(db.Integer, primary_key=True)
    date=db.Column(db.DateTime, default=db.func.current_timestamp())
    motif=db.Column(db.String(100)) #login, logout, ajout eleve, suppression, modification
    message=db.Column(db.String(256))
    
    
# Load user callback for Flask-Login
@login_manager.user_loader
def load_user(user_id):
    return User.query.get(int(user_id))

class Gerant(db.Model):
    __tablename__="_gerant"
    id = db.Column(db.Integer, primary_key=True)
    nom=db.Column(db.String(100), default="")
    credit=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
    debit=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
    credit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0)) #RETRAIT
    debit_bilan=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))  #DEPOT
    @property
    def solde(self):
        return self.solde_bilan + self.debit - self.credit
    @property
    def solde_bilan(self):
        return self.debit_bilan - self.credit_bilan
    @property
    def depot(self):
        return self.debit_bilan+self.debit
    @property
    def retrait(self):
        return self.credit_bilan+self.credit
 



